package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaConnectorBuilder extends KafkaConnectorFluent<KafkaConnectorBuilder> implements VisitableBuilder<KafkaConnector,KafkaConnectorBuilder>{
  public KafkaConnectorBuilder() {
    this(new KafkaConnector());
  }
  
  public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent) {
    this(fluent, new KafkaConnector());
  }
  
  public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent,KafkaConnector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaConnectorBuilder(KafkaConnector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaConnectorFluent<?> fluent;
  
  public KafkaConnector build() {
    KafkaConnector buildable = new KafkaConnector(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}