package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AutoRestartStatusBuilder extends AutoRestartStatusFluent<AutoRestartStatusBuilder> implements VisitableBuilder<AutoRestartStatus,AutoRestartStatusBuilder>{
  public AutoRestartStatusBuilder() {
    this(new AutoRestartStatus());
  }
  
  public AutoRestartStatusBuilder(AutoRestartStatusFluent<?> fluent) {
    this(fluent, new AutoRestartStatus());
  }
  
  public AutoRestartStatusBuilder(AutoRestartStatusFluent<?> fluent,AutoRestartStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AutoRestartStatusBuilder(AutoRestartStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AutoRestartStatusFluent<?> fluent;
  
  public AutoRestartStatus build() {
    AutoRestartStatus buildable = new AutoRestartStatus();
    buildable.setCount(fluent.getCount());
    buildable.setConnectorName(fluent.getConnectorName());
    buildable.setLastRestartTimestamp(fluent.getLastRestartTimestamp());
    return buildable;
  }
  

}