package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AutoRestartBuilder extends AutoRestartFluent<AutoRestartBuilder> implements VisitableBuilder<AutoRestart,AutoRestartBuilder>{
  public AutoRestartBuilder() {
    this(new AutoRestart());
  }
  
  public AutoRestartBuilder(AutoRestartFluent<?> fluent) {
    this(fluent, new AutoRestart());
  }
  
  public AutoRestartBuilder(AutoRestartFluent<?> fluent,AutoRestart instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AutoRestartBuilder(AutoRestart instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AutoRestartFluent<?> fluent;
  
  public AutoRestart build() {
    AutoRestart buildable = new AutoRestart();
    buildable.setEnabled(fluent.isEnabled());
    buildable.setMaxRestarts(fluent.getMaxRestarts());
    return buildable;
  }
  

}