package io.strimzi.api.kafka.model.connector;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.common.SpecFluent;
import java.lang.Integer;
import io.strimzi.api.kafka.model.common.ConnectorState;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AbstractConnectorSpecFluent<A extends AbstractConnectorSpecFluent<A>> extends SpecFluent<A>{
  public AbstractConnectorSpecFluent() {
  }
  
  public AbstractConnectorSpecFluent(AbstractConnectorSpec instance) {
    this.copyInstance(instance);
  }
  private Integer tasksMax;
  private Boolean pause;
  private Map<String,Object> config;
  private ConnectorState state;
  private AutoRestartBuilder autoRestart;
  private ListOffsetsBuilder listOffsets;
  private AlterOffsetsBuilder alterOffsets;
  
  protected void copyInstance(AbstractConnectorSpec instance) {
    if (instance != null) {
          this.withTasksMax(instance.getTasksMax());
          this.withPause(instance.getPause());
          this.withConfig(instance.getConfig());
          this.withState(instance.getState());
          this.withAutoRestart(instance.getAutoRestart());
          this.withListOffsets(instance.getListOffsets());
          this.withAlterOffsets(instance.getAlterOffsets());
        }
  }
  
  public Integer getTasksMax() {
    return this.tasksMax;
  }
  
  public A withTasksMax(Integer tasksMax) {
    this.tasksMax = tasksMax;
    return (A) this;
  }
  
  public boolean hasTasksMax() {
    return this.tasksMax != null;
  }
  
  public Boolean getPause() {
    return this.pause;
  }
  
  public A withPause(Boolean pause) {
    this.pause = pause;
    return (A) this;
  }
  
  public boolean hasPause() {
    return this.pause != null;
  }
  
  public A addToConfig(String key,Object value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  
  public A addToConfig(Map<String,Object> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  
  public A removeFromConfig(Map<String,Object> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getConfig() {
    return this.config;
  }
  
  public <K,V>A withConfig(Map<String,Object> config) {
    if (config == null) {
      this.config = null;
    } else {
      this.config = new LinkedHashMap(config);
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public ConnectorState getState() {
    return this.state;
  }
  
  public A withState(ConnectorState state) {
    this.state = state;
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public AutoRestart buildAutoRestart() {
    return this.autoRestart != null ? this.autoRestart.build() : null;
  }
  
  public A withAutoRestart(AutoRestart autoRestart) {
    this._visitables.remove("autoRestart");
    if (autoRestart != null) {
        this.autoRestart = new AutoRestartBuilder(autoRestart);
        this._visitables.get("autoRestart").add(this.autoRestart);
    } else {
        this.autoRestart = null;
        this._visitables.get("autoRestart").remove(this.autoRestart);
    }
    return (A) this;
  }
  
  public boolean hasAutoRestart() {
    return this.autoRestart != null;
  }
  
  public AutoRestartNested<A> withNewAutoRestart() {
    return new AutoRestartNested(null);
  }
  
  public AutoRestartNested<A> withNewAutoRestartLike(AutoRestart item) {
    return new AutoRestartNested(item);
  }
  
  public AutoRestartNested<A> editAutoRestart() {
    return withNewAutoRestartLike(java.util.Optional.ofNullable(buildAutoRestart()).orElse(null));
  }
  
  public AutoRestartNested<A> editOrNewAutoRestart() {
    return withNewAutoRestartLike(java.util.Optional.ofNullable(buildAutoRestart()).orElse(new AutoRestartBuilder().build()));
  }
  
  public AutoRestartNested<A> editOrNewAutoRestartLike(AutoRestart item) {
    return withNewAutoRestartLike(java.util.Optional.ofNullable(buildAutoRestart()).orElse(item));
  }
  
  public ListOffsets buildListOffsets() {
    return this.listOffsets != null ? this.listOffsets.build() : null;
  }
  
  public A withListOffsets(ListOffsets listOffsets) {
    this._visitables.remove("listOffsets");
    if (listOffsets != null) {
        this.listOffsets = new ListOffsetsBuilder(listOffsets);
        this._visitables.get("listOffsets").add(this.listOffsets);
    } else {
        this.listOffsets = null;
        this._visitables.get("listOffsets").remove(this.listOffsets);
    }
    return (A) this;
  }
  
  public boolean hasListOffsets() {
    return this.listOffsets != null;
  }
  
  public ListOffsetsNested<A> withNewListOffsets() {
    return new ListOffsetsNested(null);
  }
  
  public ListOffsetsNested<A> withNewListOffsetsLike(ListOffsets item) {
    return new ListOffsetsNested(item);
  }
  
  public ListOffsetsNested<A> editListOffsets() {
    return withNewListOffsetsLike(java.util.Optional.ofNullable(buildListOffsets()).orElse(null));
  }
  
  public ListOffsetsNested<A> editOrNewListOffsets() {
    return withNewListOffsetsLike(java.util.Optional.ofNullable(buildListOffsets()).orElse(new ListOffsetsBuilder().build()));
  }
  
  public ListOffsetsNested<A> editOrNewListOffsetsLike(ListOffsets item) {
    return withNewListOffsetsLike(java.util.Optional.ofNullable(buildListOffsets()).orElse(item));
  }
  
  public AlterOffsets buildAlterOffsets() {
    return this.alterOffsets != null ? this.alterOffsets.build() : null;
  }
  
  public A withAlterOffsets(AlterOffsets alterOffsets) {
    this._visitables.remove("alterOffsets");
    if (alterOffsets != null) {
        this.alterOffsets = new AlterOffsetsBuilder(alterOffsets);
        this._visitables.get("alterOffsets").add(this.alterOffsets);
    } else {
        this.alterOffsets = null;
        this._visitables.get("alterOffsets").remove(this.alterOffsets);
    }
    return (A) this;
  }
  
  public boolean hasAlterOffsets() {
    return this.alterOffsets != null;
  }
  
  public AlterOffsetsNested<A> withNewAlterOffsets() {
    return new AlterOffsetsNested(null);
  }
  
  public AlterOffsetsNested<A> withNewAlterOffsetsLike(AlterOffsets item) {
    return new AlterOffsetsNested(item);
  }
  
  public AlterOffsetsNested<A> editAlterOffsets() {
    return withNewAlterOffsetsLike(java.util.Optional.ofNullable(buildAlterOffsets()).orElse(null));
  }
  
  public AlterOffsetsNested<A> editOrNewAlterOffsets() {
    return withNewAlterOffsetsLike(java.util.Optional.ofNullable(buildAlterOffsets()).orElse(new AlterOffsetsBuilder().build()));
  }
  
  public AlterOffsetsNested<A> editOrNewAlterOffsetsLike(AlterOffsets item) {
    return withNewAlterOffsetsLike(java.util.Optional.ofNullable(buildAlterOffsets()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AbstractConnectorSpecFluent that = (AbstractConnectorSpecFluent) o;
    if (!java.util.Objects.equals(tasksMax, that.tasksMax)) return false;
    if (!java.util.Objects.equals(pause, that.pause)) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(autoRestart, that.autoRestart)) return false;
    if (!java.util.Objects.equals(listOffsets, that.listOffsets)) return false;
    if (!java.util.Objects.equals(alterOffsets, that.alterOffsets)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(tasksMax,  pause,  config,  state,  autoRestart,  listOffsets,  alterOffsets,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (tasksMax != null) { sb.append("tasksMax:"); sb.append(tasksMax + ","); }
    if (pause != null) { sb.append("pause:"); sb.append(pause + ","); }
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (autoRestart != null) { sb.append("autoRestart:"); sb.append(autoRestart + ","); }
    if (listOffsets != null) { sb.append("listOffsets:"); sb.append(listOffsets + ","); }
    if (alterOffsets != null) { sb.append("alterOffsets:"); sb.append(alterOffsets); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withPause() {
    return withPause(true);
  }
  public class AutoRestartNested<N> extends AutoRestartFluent<AutoRestartNested<N>> implements Nested<N>{
    AutoRestartNested(AutoRestart item) {
      this.builder = new AutoRestartBuilder(this, item);
    }
    AutoRestartBuilder builder;
    
    public N and() {
      return (N) AbstractConnectorSpecFluent.this.withAutoRestart(builder.build());
    }
    
    public N endAutoRestart() {
      return and();
    }
    
  
  }
  public class ListOffsetsNested<N> extends ListOffsetsFluent<ListOffsetsNested<N>> implements Nested<N>{
    ListOffsetsNested(ListOffsets item) {
      this.builder = new ListOffsetsBuilder(this, item);
    }
    ListOffsetsBuilder builder;
    
    public N and() {
      return (N) AbstractConnectorSpecFluent.this.withListOffsets(builder.build());
    }
    
    public N endListOffsets() {
      return and();
    }
    
  
  }
  public class AlterOffsetsNested<N> extends AlterOffsetsFluent<AlterOffsetsNested<N>> implements Nested<N>{
    AlterOffsetsNested(AlterOffsets item) {
      this.builder = new AlterOffsetsBuilder(this, item);
    }
    AlterOffsetsBuilder builder;
    
    public N and() {
      return (N) AbstractConnectorSpecFluent.this.withAlterOffsets(builder.build());
    }
    
    public N endAlterOffsets() {
      return and();
    }
    
  
  }

}