package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ZipArtifactBuilder extends ZipArtifactFluent<ZipArtifactBuilder> implements VisitableBuilder<ZipArtifact,ZipArtifactBuilder>{
  public ZipArtifactBuilder() {
    this(new ZipArtifact());
  }
  
  public ZipArtifactBuilder(ZipArtifactFluent<?> fluent) {
    this(fluent, new ZipArtifact());
  }
  
  public ZipArtifactBuilder(ZipArtifactFluent<?> fluent,ZipArtifact instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ZipArtifactBuilder(ZipArtifact instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ZipArtifactFluent<?> fluent;
  
  public ZipArtifact build() {
    ZipArtifact buildable = new ZipArtifact();
    buildable.setUrl(fluent.getUrl());
    buildable.setSha512sum(fluent.getSha512sum());
    buildable.setInsecure(fluent.getInsecure());
    return buildable;
  }
  

}