package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TgzArtifactBuilder extends TgzArtifactFluent<TgzArtifactBuilder> implements VisitableBuilder<TgzArtifact,TgzArtifactBuilder>{
  public TgzArtifactBuilder() {
    this(new TgzArtifact());
  }
  
  public TgzArtifactBuilder(TgzArtifactFluent<?> fluent) {
    this(fluent, new TgzArtifact());
  }
  
  public TgzArtifactBuilder(TgzArtifactFluent<?> fluent,TgzArtifact instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TgzArtifactBuilder(TgzArtifact instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TgzArtifactFluent<?> fluent;
  
  public TgzArtifact build() {
    TgzArtifact buildable = new TgzArtifact();
    buildable.setUrl(fluent.getUrl());
    buildable.setSha512sum(fluent.getSha512sum());
    buildable.setInsecure(fluent.getInsecure());
    return buildable;
  }
  

}