package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PluginBuilder extends PluginFluent<PluginBuilder> implements VisitableBuilder<Plugin,PluginBuilder>{
  public PluginBuilder() {
    this(new Plugin());
  }
  
  public PluginBuilder(PluginFluent<?> fluent) {
    this(fluent, new Plugin());
  }
  
  public PluginBuilder(PluginFluent<?> fluent,Plugin instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PluginBuilder(Plugin instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PluginFluent<?> fluent;
  
  public Plugin build() {
    Plugin buildable = new Plugin();
    buildable.setName(fluent.getName());
    buildable.setArtifacts(fluent.buildArtifacts());
    return buildable;
  }
  

}