package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OtherArtifactBuilder extends OtherArtifactFluent<OtherArtifactBuilder> implements VisitableBuilder<OtherArtifact,OtherArtifactBuilder>{
  public OtherArtifactBuilder() {
    this(new OtherArtifact());
  }
  
  public OtherArtifactBuilder(OtherArtifactFluent<?> fluent) {
    this(fluent, new OtherArtifact());
  }
  
  public OtherArtifactBuilder(OtherArtifactFluent<?> fluent,OtherArtifact instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OtherArtifactBuilder(OtherArtifact instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OtherArtifactFluent<?> fluent;
  
  public OtherArtifact build() {
    OtherArtifact buildable = new OtherArtifact();
    buildable.setFileName(fluent.getFileName());
    buildable.setUrl(fluent.getUrl());
    buildable.setSha512sum(fluent.getSha512sum());
    buildable.setInsecure(fluent.getInsecure());
    return buildable;
  }
  

}