package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MavenArtifactBuilder extends MavenArtifactFluent<MavenArtifactBuilder> implements VisitableBuilder<MavenArtifact,MavenArtifactBuilder>{
  public MavenArtifactBuilder() {
    this(new MavenArtifact());
  }
  
  public MavenArtifactBuilder(MavenArtifactFluent<?> fluent) {
    this(fluent, new MavenArtifact());
  }
  
  public MavenArtifactBuilder(MavenArtifactFluent<?> fluent,MavenArtifact instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MavenArtifactBuilder(MavenArtifact instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MavenArtifactFluent<?> fluent;
  
  public MavenArtifact build() {
    MavenArtifact buildable = new MavenArtifact();
    buildable.setGroup(fluent.getGroup());
    buildable.setArtifact(fluent.getArtifact());
    buildable.setVersion(fluent.getVersion());
    buildable.setRepository(fluent.getRepository());
    buildable.setInsecure(fluent.getInsecure());
    return buildable;
  }
  

}