package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JarArtifactBuilder extends JarArtifactFluent<JarArtifactBuilder> implements VisitableBuilder<JarArtifact,JarArtifactBuilder>{
  public JarArtifactBuilder() {
    this(new JarArtifact());
  }
  
  public JarArtifactBuilder(JarArtifactFluent<?> fluent) {
    this(fluent, new JarArtifact());
  }
  
  public JarArtifactBuilder(JarArtifactFluent<?> fluent,JarArtifact instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JarArtifactBuilder(JarArtifact instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JarArtifactFluent<?> fluent;
  
  public JarArtifact build() {
    JarArtifact buildable = new JarArtifact();
    buildable.setUrl(fluent.getUrl());
    buildable.setSha512sum(fluent.getSha512sum());
    buildable.setInsecure(fluent.getInsecure());
    return buildable;
  }
  

}