package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageStreamOutputBuilder extends ImageStreamOutputFluent<ImageStreamOutputBuilder> implements VisitableBuilder<ImageStreamOutput,ImageStreamOutputBuilder>{
  public ImageStreamOutputBuilder() {
    this(new ImageStreamOutput());
  }
  
  public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent) {
    this(fluent, new ImageStreamOutput());
  }
  
  public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent,ImageStreamOutput instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageStreamOutputBuilder(ImageStreamOutput instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageStreamOutputFluent<?> fluent;
  
  public ImageStreamOutput build() {
    ImageStreamOutput buildable = new ImageStreamOutput();
    buildable.setImage(fluent.getImage());
    return buildable;
  }
  

}