package io.strimzi.api.kafka.model.connect.build;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DownloadableArtifactFluent<A extends DownloadableArtifactFluent<A>> extends BaseFluent<A>{
  public DownloadableArtifactFluent() {
  }
  
  public DownloadableArtifactFluent(DownloadableArtifact instance) {
    this.copyInstance(instance);
  }
  private String url;
  private String sha512sum;
  private Boolean insecure;
  
  protected void copyInstance(DownloadableArtifact instance) {
    if (instance != null) {
          this.withUrl(instance.getUrl());
          this.withSha512sum(instance.getSha512sum());
          this.withInsecure(instance.getInsecure());
        }
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public String getSha512sum() {
    return this.sha512sum;
  }
  
  public A withSha512sum(String sha512sum) {
    this.sha512sum = sha512sum;
    return (A) this;
  }
  
  public boolean hasSha512sum() {
    return this.sha512sum != null;
  }
  
  public Boolean getInsecure() {
    return this.insecure;
  }
  
  public A withInsecure(Boolean insecure) {
    this.insecure = insecure;
    return (A) this;
  }
  
  public boolean hasInsecure() {
    return this.insecure != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DownloadableArtifactFluent that = (DownloadableArtifactFluent) o;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(sha512sum, that.sha512sum)) return false;
    if (!java.util.Objects.equals(insecure, that.insecure)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(url,  sha512sum,  insecure,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (sha512sum != null) { sb.append("sha512sum:"); sb.append(sha512sum + ","); }
    if (insecure != null) { sb.append("insecure:"); sb.append(insecure); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecure() {
    return withInsecure(true);
  }
  

}