package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DockerOutputBuilder extends DockerOutputFluent<DockerOutputBuilder> implements VisitableBuilder<DockerOutput,DockerOutputBuilder>{
  public DockerOutputBuilder() {
    this(new DockerOutput());
  }
  
  public DockerOutputBuilder(DockerOutputFluent<?> fluent) {
    this(fluent, new DockerOutput());
  }
  
  public DockerOutputBuilder(DockerOutputFluent<?> fluent,DockerOutput instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DockerOutputBuilder(DockerOutput instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DockerOutputFluent<?> fluent;
  
  public DockerOutput build() {
    DockerOutput buildable = new DockerOutput();
    buildable.setPushSecret(fluent.getPushSecret());
    buildable.setAdditionalKanikoOptions(fluent.getAdditionalKanikoOptions());
    buildable.setImage(fluent.getImage());
    return buildable;
  }
  

}