package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaConnectTemplateBuilder extends KafkaConnectTemplateFluent<KafkaConnectTemplateBuilder> implements VisitableBuilder<KafkaConnectTemplate,KafkaConnectTemplateBuilder>{
  public KafkaConnectTemplateBuilder() {
    this(new KafkaConnectTemplate());
  }
  
  public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent) {
    this(fluent, new KafkaConnectTemplate());
  }
  
  public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent,KafkaConnectTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaConnectTemplateBuilder(KafkaConnectTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaConnectTemplateFluent<?> fluent;
  
  public KafkaConnectTemplate build() {
    KafkaConnectTemplate buildable = new KafkaConnectTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPodSet(fluent.buildPodSet());
    buildable.setPod(fluent.buildPod());
    buildable.setBuildPod(fluent.buildBuildPod());
    buildable.setApiService(fluent.buildApiService());
    buildable.setHeadlessService(fluent.buildHeadlessService());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setConnectContainer(fluent.buildConnectContainer());
    buildable.setInitContainer(fluent.buildInitContainer());
    buildable.setBuildContainer(fluent.buildBuildContainer());
    buildable.setBuildConfig(fluent.buildBuildConfig());
    buildable.setClusterRoleBinding(fluent.buildClusterRoleBinding());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    buildable.setBuildServiceAccount(fluent.buildBuildServiceAccount());
    buildable.setJmxSecret(fluent.buildJmxSecret());
    return buildable;
  }
  

}