package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaConnectSpecBuilder extends KafkaConnectSpecFluent<KafkaConnectSpecBuilder> implements VisitableBuilder<KafkaConnectSpec,KafkaConnectSpecBuilder>{
  public KafkaConnectSpecBuilder() {
    this(new KafkaConnectSpec());
  }
  
  public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent) {
    this(fluent, new KafkaConnectSpec());
  }
  
  public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent,KafkaConnectSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaConnectSpecBuilder(KafkaConnectSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaConnectSpecFluent<?> fluent;
  
  public KafkaConnectSpec build() {
    KafkaConnectSpec buildable = new KafkaConnectSpec();
    buildable.setConfig(fluent.getConfig());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    buildable.setBuild(fluent.buildBuild());
    buildable.setLogging(fluent.buildLogging());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setVersion(fluent.getVersion());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJmxOptions(fluent.buildJmxOptions());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setTracing(fluent.buildTracing());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setExternalConfiguration(fluent.buildExternalConfiguration());
    buildable.setClientRackInitImage(fluent.getClientRackInitImage());
    buildable.setRack(fluent.buildRack());
    return buildable;
  }
  

}