package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ExternalConfigurationVolumeSourceBuilder extends ExternalConfigurationVolumeSourceFluent<ExternalConfigurationVolumeSourceBuilder> implements VisitableBuilder<ExternalConfigurationVolumeSource,ExternalConfigurationVolumeSourceBuilder>{
  public ExternalConfigurationVolumeSourceBuilder() {
    this(new ExternalConfigurationVolumeSource());
  }
  
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSourceFluent<?> fluent) {
    this(fluent, new ExternalConfigurationVolumeSource());
  }
  
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSourceFluent<?> fluent,ExternalConfigurationVolumeSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ExternalConfigurationVolumeSourceFluent<?> fluent;
  
  public ExternalConfigurationVolumeSource build() {
    ExternalConfigurationVolumeSource buildable = new ExternalConfigurationVolumeSource();
    buildable.setName(fluent.getName());
    buildable.setSecret(fluent.getSecret());
    buildable.setConfigMap(fluent.getConfigMap());
    return buildable;
  }
  

}