package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ExternalConfigurationFluent<A extends ExternalConfigurationFluent<A>> extends BaseFluent<A>{
  public ExternalConfigurationFluent() {
  }
  
  public ExternalConfigurationFluent(ExternalConfiguration instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ExternalConfigurationEnvBuilder> env;
  private ArrayList<ExternalConfigurationVolumeSourceBuilder> volumes;
  
  protected void copyInstance(ExternalConfiguration instance) {
    instance = (instance != null ? instance : new ExternalConfiguration());
    if (instance != null) {
          this.withEnv(instance.getEnv());
          this.withVolumes(instance.getVolumes());
        }
  }
  
  public A addToEnv(int index,ExternalConfigurationEnv item) {
    if (this.env == null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>();}
    ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").add(index, builder); env.add(index, builder);}
    return (A)this;
  }
  
  public A setToEnv(int index,ExternalConfigurationEnv item) {
    if (this.env == null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>();}
    ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").set(index, builder); env.set(index, builder);}
    return (A)this;
  }
  
  public A addToEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... items) {
    if (this.env == null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>();}
    for (ExternalConfigurationEnv item : items) {ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  
  public A addAllToEnv(Collection<ExternalConfigurationEnv> items) {
    if (this.env == null) {this.env = new ArrayList<ExternalConfigurationEnvBuilder>();}
    for (ExternalConfigurationEnv item : items) {ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  
  public A removeFromEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... items) {
    if (this.env == null) return (A)this;
    for (ExternalConfigurationEnv item : items) {ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEnv(Collection<ExternalConfigurationEnv> items) {
    if (this.env == null) return (A)this;
    for (ExternalConfigurationEnv item : items) {ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEnv(Predicate<ExternalConfigurationEnvBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<ExternalConfigurationEnvBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      ExternalConfigurationEnvBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ExternalConfigurationEnv> buildEnv() {
    return this.env != null ? build(env) : null;
  }
  
  public ExternalConfigurationEnv buildEnv(int index) {
    return this.env.get(index).build();
  }
  
  public ExternalConfigurationEnv buildFirstEnv() {
    return this.env.get(0).build();
  }
  
  public ExternalConfigurationEnv buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  
  public ExternalConfigurationEnv buildMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate) {
      for (ExternalConfigurationEnvBuilder item : env) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate) {
      for (ExternalConfigurationEnvBuilder item : env) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnv(List<ExternalConfigurationEnv> env) {
    if (this.env != null) {
      this._visitables.get("env").clear();
    }
    if (env != null) {
        this.env = new ArrayList();
        for (ExternalConfigurationEnv item : env) {
          this.addToEnv(item);
        }
    } else {
      this.env = null;
    }
    return (A) this;
  }
  
  public A withEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... env) {
    if (this.env != null) {
        this.env.clear();
        _visitables.remove("env");
    }
    if (env != null) {
      for (ExternalConfigurationEnv item : env) {
        this.addToEnv(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEnv() {
    return this.env != null && !this.env.isEmpty();
  }
  
  public EnvNested<A> addNewEnv() {
    return new EnvNested(-1, null);
  }
  
  public EnvNested<A> addNewEnvLike(ExternalConfigurationEnv item) {
    return new EnvNested(-1, item);
  }
  
  public EnvNested<A> setNewEnvLike(int index,ExternalConfigurationEnv item) {
    return new EnvNested(index, item);
  }
  
  public EnvNested<A> editEnv(int index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  
  public EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public EnvNested<A> editMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public A addToVolumes(int index,ExternalConfigurationVolumeSource item) {
    if (this.volumes == null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>();}
    ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").add(index, builder); volumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToVolumes(int index,ExternalConfigurationVolumeSource item) {
    if (this.volumes == null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>();}
    ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").set(index, builder); volumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>();}
    for (ExternalConfigurationVolumeSource item : items) {ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  
  public A addAllToVolumes(Collection<ExternalConfigurationVolumeSource> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<ExternalConfigurationVolumeSourceBuilder>();}
    for (ExternalConfigurationVolumeSource item : items) {ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  
  public A removeFromVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... items) {
    if (this.volumes == null) return (A)this;
    for (ExternalConfigurationVolumeSource item : items) {ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").remove(builder); this.volumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVolumes(Collection<ExternalConfigurationVolumeSource> items) {
    if (this.volumes == null) return (A)this;
    for (ExternalConfigurationVolumeSource item : items) {ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").remove(builder); this.volumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVolumes(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<ExternalConfigurationVolumeSourceBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      ExternalConfigurationVolumeSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ExternalConfigurationVolumeSource> buildVolumes() {
    return this.volumes != null ? build(volumes) : null;
  }
  
  public ExternalConfigurationVolumeSource buildVolume(int index) {
    return this.volumes.get(index).build();
  }
  
  public ExternalConfigurationVolumeSource buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  
  public ExternalConfigurationVolumeSource buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  
  public ExternalConfigurationVolumeSource buildMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate) {
      for (ExternalConfigurationVolumeSourceBuilder item : volumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate) {
      for (ExternalConfigurationVolumeSourceBuilder item : volumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumes(List<ExternalConfigurationVolumeSource> volumes) {
    if (this.volumes != null) {
      this._visitables.get("volumes").clear();
    }
    if (volumes != null) {
        this.volumes = new ArrayList();
        for (ExternalConfigurationVolumeSource item : volumes) {
          this.addToVolumes(item);
        }
    } else {
      this.volumes = null;
    }
    return (A) this;
  }
  
  public A withVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... volumes) {
    if (this.volumes != null) {
        this.volumes.clear();
        _visitables.remove("volumes");
    }
    if (volumes != null) {
      for (ExternalConfigurationVolumeSource item : volumes) {
        this.addToVolumes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumes() {
    return this.volumes != null && !this.volumes.isEmpty();
  }
  
  public VolumesNested<A> addNewVolume() {
    return new VolumesNested(-1, null);
  }
  
  public VolumesNested<A> addNewVolumeLike(ExternalConfigurationVolumeSource item) {
    return new VolumesNested(-1, item);
  }
  
  public VolumesNested<A> setNewVolumeLike(int index,ExternalConfigurationVolumeSource item) {
    return new VolumesNested(index, item);
  }
  
  public VolumesNested<A> editVolume(int index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  
  public VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public VolumesNested<A> editMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExternalConfigurationFluent that = (ExternalConfigurationFluent) o;
    if (!java.util.Objects.equals(env, that.env)) return false;
    if (!java.util.Objects.equals(volumes, that.volumes)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(env,  volumes,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes); }
    sb.append("}");
    return sb.toString();
  }
  public class EnvNested<N> extends ExternalConfigurationEnvFluent<EnvNested<N>> implements Nested<N>{
    EnvNested(int index,ExternalConfigurationEnv item) {
      this.index = index;
      this.builder = new ExternalConfigurationEnvBuilder(this, item);
    }
    ExternalConfigurationEnvBuilder builder;
    int index;
    
    public N and() {
      return (N) ExternalConfigurationFluent.this.setToEnv(index,builder.build());
    }
    
    public N endEnv() {
      return and();
    }
    
  
  }
  public class VolumesNested<N> extends ExternalConfigurationVolumeSourceFluent<VolumesNested<N>> implements Nested<N>{
    VolumesNested(int index,ExternalConfigurationVolumeSource item) {
      this.index = index;
      this.builder = new ExternalConfigurationVolumeSourceBuilder(this, item);
    }
    ExternalConfigurationVolumeSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) ExternalConfigurationFluent.this.setToVolumes(index,builder.build());
    }
    
    public N endVolume() {
      return and();
    }
    
  
  }

}