package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ExternalConfigurationEnvVarSourceBuilder extends ExternalConfigurationEnvVarSourceFluent<ExternalConfigurationEnvVarSourceBuilder> implements VisitableBuilder<ExternalConfigurationEnvVarSource,ExternalConfigurationEnvVarSourceBuilder>{
  public ExternalConfigurationEnvVarSourceBuilder() {
    this(new ExternalConfigurationEnvVarSource());
  }
  
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent) {
    this(fluent, new ExternalConfigurationEnvVarSource());
  }
  
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent,ExternalConfigurationEnvVarSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ExternalConfigurationEnvVarSourceFluent<?> fluent;
  
  public ExternalConfigurationEnvVarSource build() {
    ExternalConfigurationEnvVarSource buildable = new ExternalConfigurationEnvVarSource();
    buildable.setSecretKeyRef(fluent.getSecretKeyRef());
    buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
    return buildable;
  }
  

}