package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ExternalConfigurationEnvBuilder extends ExternalConfigurationEnvFluent<ExternalConfigurationEnvBuilder> implements VisitableBuilder<ExternalConfigurationEnv,ExternalConfigurationEnvBuilder>{
  public ExternalConfigurationEnvBuilder() {
    this(new ExternalConfigurationEnv());
  }
  
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent) {
    this(fluent, new ExternalConfigurationEnv());
  }
  
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent,ExternalConfigurationEnv instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnv instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ExternalConfigurationEnvFluent<?> fluent;
  
  public ExternalConfigurationEnv build() {
    ExternalConfigurationEnv buildable = new ExternalConfigurationEnv();
    buildable.setName(fluent.getName());
    buildable.setValueFrom(fluent.buildValueFrom());
    return buildable;
  }
  

}