package io.strimzi.api.kafka.model.connect;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConnectorPluginFluent<A extends ConnectorPluginFluent<A>> extends BaseFluent<A>{
  public ConnectorPluginFluent() {
  }
  
  public ConnectorPluginFluent(ConnectorPlugin instance) {
    this.copyInstance(instance);
  }
  private String connectorClass;
  private String type;
  private String version;
  
  protected void copyInstance(ConnectorPlugin instance) {
    instance = (instance != null ? instance : new ConnectorPlugin());
    if (instance != null) {
          this.withConnectorClass(instance.getConnectorClass());
          this.withType(instance.getType());
          this.withVersion(instance.getVersion());
        }
  }
  
  public String getConnectorClass() {
    return this.connectorClass;
  }
  
  public A withConnectorClass(String connectorClass) {
    this.connectorClass = connectorClass;
    return (A) this;
  }
  
  public boolean hasConnectorClass() {
    return this.connectorClass != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConnectorPluginFluent that = (ConnectorPluginFluent) o;
    if (!java.util.Objects.equals(connectorClass, that.connectorClass)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(connectorClass,  type,  version,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectorClass != null) { sb.append("connectorClass:"); sb.append(connectorClass + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  

}