package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConnectorPluginBuilder extends ConnectorPluginFluent<ConnectorPluginBuilder> implements VisitableBuilder<ConnectorPlugin,ConnectorPluginBuilder>{
  public ConnectorPluginBuilder() {
    this(new ConnectorPlugin());
  }
  
  public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent) {
    this(fluent, new ConnectorPlugin());
  }
  
  public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent,ConnectorPlugin instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConnectorPluginBuilder(ConnectorPlugin instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConnectorPluginFluent<?> fluent;
  
  public ConnectorPlugin build() {
    ConnectorPlugin buildable = new ConnectorPlugin();
    buildable.setConnectorClass(fluent.getConnectorClass());
    buildable.setType(fluent.getType());
    buildable.setVersion(fluent.getVersion());
    return buildable;
  }
  

}