package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.RackBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsFluent;
import java.lang.String;
import io.strimzi.api.kafka.model.common.Probe;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracing;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracingFluent;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.RackFluent;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptionsFluent;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracingFluent;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptionsBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.tracing.Tracing;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracingBuilder;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracingBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.Rack;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.common.ExternalLogging;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptions;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AbstractKafkaConnectSpecFluent<A extends AbstractKafkaConnectSpecFluent<A>> extends SpecFluent<A>{
  public AbstractKafkaConnectSpecFluent() {
  }
  
  public AbstractKafkaConnectSpecFluent(AbstractKafkaConnectSpec instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends Logging,?> logging;
  private int replicas;
  private String version;
  private String image;
  private ResourceRequirements resources;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private KafkaJmxOptionsBuilder jmxOptions;
  private JvmOptionsBuilder jvmOptions;
  private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;
  private VisitableBuilder<? extends Tracing,?> tracing;
  private KafkaConnectTemplateBuilder template;
  private ExternalConfigurationBuilder externalConfiguration;
  private String clientRackInitImage;
  private RackBuilder rack;
  
  protected void copyInstance(AbstractKafkaConnectSpec instance) {
    if (instance != null) {
          this.withLogging(instance.getLogging());
          this.withReplicas(instance.getReplicas());
          this.withVersion(instance.getVersion());
          this.withImage(instance.getImage());
          this.withResources(instance.getResources());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withJmxOptions(instance.getJmxOptions());
          this.withJvmOptions(instance.getJvmOptions());
          this.withMetricsConfig(instance.getMetricsConfig());
          this.withTracing(instance.getTracing());
          this.withTemplate(instance.getTemplate());
          this.withExternalConfiguration(instance.getExternalConfiguration());
          this.withClientRackInitImage(instance.getClientRackInitImage());
          this.withRack(instance.getRack());
        }
  }
  
  public Logging buildLogging() {
    return this.logging != null ? this.logging.build() : null;
  }
  
  public A withLogging(Logging logging) {
    if (logging == null) {
        this.logging = null;
        this._visitables.remove("logging");
        return (A) this;
    } else {
        VisitableBuilder<? extends Logging,?> builder = builder(logging);;
        this._visitables.get("logging").clear();
        this._visitables.get("logging").add(builder);
        this.logging = builder;
        return (A) this;
    }
  }
  
  public boolean hasLogging() {
    return this.logging != null;
  }
  
  public InlineLoggingNested<A> withNewInlineLogging() {
    return new InlineLoggingNested(null);
  }
  
  public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
    return new InlineLoggingNested(item);
  }
  
  public ExternalLoggingNested<A> withNewExternalLogging() {
    return new ExternalLoggingNested(null);
  }
  
  public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
    return new ExternalLoggingNested(item);
  }
  
  public int getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(int replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return true;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public ResourceRequirements getResources() {
    return this.resources;
  }
  
  public A withResources(ResourceRequirements resources) {
    this.resources = resources;
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public Probe buildLivenessProbe() {
    return this.livenessProbe != null ? this.livenessProbe.build() : null;
  }
  
  public A withLivenessProbe(Probe livenessProbe) {
    this._visitables.remove("livenessProbe");
    if (livenessProbe != null) {
        this.livenessProbe = new ProbeBuilder(livenessProbe);
        this._visitables.get("livenessProbe").add(this.livenessProbe);
    } else {
        this.livenessProbe = null;
        this._visitables.get("livenessProbe").remove(this.livenessProbe);
    }
    return (A) this;
  }
  
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  
  public Probe buildReadinessProbe() {
    return this.readinessProbe != null ? this.readinessProbe.build() : null;
  }
  
  public A withReadinessProbe(Probe readinessProbe) {
    this._visitables.remove("readinessProbe");
    if (readinessProbe != null) {
        this.readinessProbe = new ProbeBuilder(readinessProbe);
        this._visitables.get("readinessProbe").add(this.readinessProbe);
    } else {
        this.readinessProbe = null;
        this._visitables.get("readinessProbe").remove(this.readinessProbe);
    }
    return (A) this;
  }
  
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  
  public KafkaJmxOptions buildJmxOptions() {
    return this.jmxOptions != null ? this.jmxOptions.build() : null;
  }
  
  public A withJmxOptions(KafkaJmxOptions jmxOptions) {
    this._visitables.remove("jmxOptions");
    if (jmxOptions != null) {
        this.jmxOptions = new KafkaJmxOptionsBuilder(jmxOptions);
        this._visitables.get("jmxOptions").add(this.jmxOptions);
    } else {
        this.jmxOptions = null;
        this._visitables.get("jmxOptions").remove(this.jmxOptions);
    }
    return (A) this;
  }
  
  public boolean hasJmxOptions() {
    return this.jmxOptions != null;
  }
  
  public JmxOptionsNested<A> withNewJmxOptions() {
    return new JmxOptionsNested(null);
  }
  
  public JmxOptionsNested<A> withNewJmxOptionsLike(KafkaJmxOptions item) {
    return new JmxOptionsNested(item);
  }
  
  public JmxOptionsNested<A> editJmxOptions() {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(null));
  }
  
  public JmxOptionsNested<A> editOrNewJmxOptions() {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(new KafkaJmxOptionsBuilder().build()));
  }
  
  public JmxOptionsNested<A> editOrNewJmxOptionsLike(KafkaJmxOptions item) {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(item));
  }
  
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions != null ? this.jvmOptions.build() : null;
  }
  
  public A withJvmOptions(JvmOptions jvmOptions) {
    this._visitables.remove("jvmOptions");
    if (jvmOptions != null) {
        this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
        this._visitables.get("jvmOptions").add(this.jvmOptions);
    } else {
        this.jvmOptions = null;
        this._visitables.get("jvmOptions").remove(this.jvmOptions);
    }
    return (A) this;
  }
  
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  
  public MetricsConfig buildMetricsConfig() {
    return this.metricsConfig != null ? this.metricsConfig.build() : null;
  }
  
  public A withMetricsConfig(MetricsConfig metricsConfig) {
    if (metricsConfig == null) {
        this.metricsConfig = null;
        this._visitables.remove("metricsConfig");
        return (A) this;
    } else {
        VisitableBuilder<? extends MetricsConfig,?> builder = builder(metricsConfig);;
        this._visitables.get("metricsConfig").clear();
        this._visitables.get("metricsConfig").add(builder);
        this.metricsConfig = builder;
        return (A) this;
    }
  }
  
  public boolean hasMetricsConfig() {
    return this.metricsConfig != null;
  }
  
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
    return new JmxPrometheusExporterMetricsConfigNested(null);
  }
  
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
    return new JmxPrometheusExporterMetricsConfigNested(item);
  }
  
  public Tracing buildTracing() {
    return this.tracing != null ? this.tracing.build() : null;
  }
  
  public A withTracing(Tracing tracing) {
    if (tracing == null) {
        this.tracing = null;
        this._visitables.remove("tracing");
        return (A) this;
    } else {
        VisitableBuilder<? extends Tracing,?> builder = builder(tracing);;
        this._visitables.get("tracing").clear();
        this._visitables.get("tracing").add(builder);
        this.tracing = builder;
        return (A) this;
    }
  }
  
  public boolean hasTracing() {
    return this.tracing != null;
  }
  
  public JaegerTracingNested<A> withNewJaegerTracing() {
    return new JaegerTracingNested(null);
  }
  
  public JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item) {
    return new JaegerTracingNested(item);
  }
  
  public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracing() {
    return new OpenTelemetryTracingNested(null);
  }
  
  public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracingLike(OpenTelemetryTracing item) {
    return new OpenTelemetryTracingNested(item);
  }
  
  public KafkaConnectTemplate buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(KafkaConnectTemplate template) {
    this._visitables.remove("template");
    if (template != null) {
        this.template = new KafkaConnectTemplateBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(KafkaConnectTemplate item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new KafkaConnectTemplateBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(KafkaConnectTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public ExternalConfiguration buildExternalConfiguration() {
    return this.externalConfiguration != null ? this.externalConfiguration.build() : null;
  }
  
  public A withExternalConfiguration(ExternalConfiguration externalConfiguration) {
    this._visitables.remove("externalConfiguration");
    if (externalConfiguration != null) {
        this.externalConfiguration = new ExternalConfigurationBuilder(externalConfiguration);
        this._visitables.get("externalConfiguration").add(this.externalConfiguration);
    } else {
        this.externalConfiguration = null;
        this._visitables.get("externalConfiguration").remove(this.externalConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasExternalConfiguration() {
    return this.externalConfiguration != null;
  }
  
  public ExternalConfigurationNested<A> withNewExternalConfiguration() {
    return new ExternalConfigurationNested(null);
  }
  
  public ExternalConfigurationNested<A> withNewExternalConfigurationLike(ExternalConfiguration item) {
    return new ExternalConfigurationNested(item);
  }
  
  public ExternalConfigurationNested<A> editExternalConfiguration() {
    return withNewExternalConfigurationLike(java.util.Optional.ofNullable(buildExternalConfiguration()).orElse(null));
  }
  
  public ExternalConfigurationNested<A> editOrNewExternalConfiguration() {
    return withNewExternalConfigurationLike(java.util.Optional.ofNullable(buildExternalConfiguration()).orElse(new ExternalConfigurationBuilder().build()));
  }
  
  public ExternalConfigurationNested<A> editOrNewExternalConfigurationLike(ExternalConfiguration item) {
    return withNewExternalConfigurationLike(java.util.Optional.ofNullable(buildExternalConfiguration()).orElse(item));
  }
  
  public String getClientRackInitImage() {
    return this.clientRackInitImage;
  }
  
  public A withClientRackInitImage(String clientRackInitImage) {
    this.clientRackInitImage = clientRackInitImage;
    return (A) this;
  }
  
  public boolean hasClientRackInitImage() {
    return this.clientRackInitImage != null;
  }
  
  public Rack buildRack() {
    return this.rack != null ? this.rack.build() : null;
  }
  
  public A withRack(Rack rack) {
    this._visitables.remove("rack");
    if (rack != null) {
        this.rack = new RackBuilder(rack);
        this._visitables.get("rack").add(this.rack);
    } else {
        this.rack = null;
        this._visitables.get("rack").remove(this.rack);
    }
    return (A) this;
  }
  
  public boolean hasRack() {
    return this.rack != null;
  }
  
  public A withNewRack(String topologyKey) {
    return (A)withRack(new Rack(topologyKey));
  }
  
  public RackNested<A> withNewRack() {
    return new RackNested(null);
  }
  
  public RackNested<A> withNewRackLike(Rack item) {
    return new RackNested(item);
  }
  
  public RackNested<A> editRack() {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(null));
  }
  
  public RackNested<A> editOrNewRack() {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(new RackBuilder().build()));
  }
  
  public RackNested<A> editOrNewRackLike(Rack item) {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AbstractKafkaConnectSpecFluent that = (AbstractKafkaConnectSpecFluent) o;
    if (!java.util.Objects.equals(logging, that.logging)) return false;
    if (replicas != that.replicas) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;
    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;
    if (!java.util.Objects.equals(jmxOptions, that.jmxOptions)) return false;
    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;
    if (!java.util.Objects.equals(metricsConfig, that.metricsConfig)) return false;
    if (!java.util.Objects.equals(tracing, that.tracing)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(externalConfiguration, that.externalConfiguration)) return false;
    if (!java.util.Objects.equals(clientRackInitImage, that.clientRackInitImage)) return false;
    if (!java.util.Objects.equals(rack, that.rack)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(logging,  replicas,  version,  image,  resources,  livenessProbe,  readinessProbe,  jmxOptions,  jvmOptions,  metricsConfig,  tracing,  template,  externalConfiguration,  clientRackInitImage,  rack,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    sb.append("replicas:"); sb.append(replicas + ",");
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (jmxOptions != null) { sb.append("jmxOptions:"); sb.append(jmxOptions + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions + ","); }
    if (metricsConfig != null) { sb.append("metricsConfig:"); sb.append(metricsConfig + ","); }
    if (tracing != null) { sb.append("tracing:"); sb.append(tracing + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (externalConfiguration != null) { sb.append("externalConfiguration:"); sb.append(externalConfiguration + ","); }
    if (clientRackInitImage != null) { sb.append("clientRackInitImage:"); sb.append(clientRackInitImage + ","); }
    if (rack != null) { sb.append("rack:"); sb.append(rack); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.common."+"InlineLogging": return (VisitableBuilder<T, ?>)new InlineLoggingBuilder((InlineLogging) item);
    case "io.strimzi.api.kafka.model.common."+"ExternalLogging": return (VisitableBuilder<T, ?>)new ExternalLoggingBuilder((ExternalLogging) item);
    case "io.strimzi.api.kafka.model.common.metrics."+"JmxPrometheusExporterMetrics": return (VisitableBuilder<T, ?>)new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics) item);
    case "io.strimzi.api.kafka.model.common.tracing."+"JaegerTracing": return (VisitableBuilder<T, ?>)new JaegerTracingBuilder((JaegerTracing) item);
    case "io.strimzi.api.kafka.model.common.tracing."+"OpenTelemetryTracing": return (VisitableBuilder<T, ?>)new OpenTelemetryTracingBuilder((OpenTelemetryTracing) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class InlineLoggingNested<N> extends InlineLoggingFluent<InlineLoggingNested<N>> implements Nested<N>{
    InlineLoggingNested(InlineLogging item) {
      this.builder = new InlineLoggingBuilder(this, item);
    }
    InlineLoggingBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withLogging(builder.build());
    }
    
    public N endInlineLogging() {
      return and();
    }
    
  
  }
  public class ExternalLoggingNested<N> extends ExternalLoggingFluent<ExternalLoggingNested<N>> implements Nested<N>{
    ExternalLoggingNested(ExternalLogging item) {
      this.builder = new ExternalLoggingBuilder(this, item);
    }
    ExternalLoggingBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withLogging(builder.build());
    }
    
    public N endExternalLogging() {
      return and();
    }
    
  
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withLivenessProbe(builder.build());
    }
    
    public N endLivenessProbe() {
      return and();
    }
    
  
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withReadinessProbe(builder.build());
    }
    
    public N endReadinessProbe() {
      return and();
    }
    
  
  }
  public class JmxOptionsNested<N> extends KafkaJmxOptionsFluent<JmxOptionsNested<N>> implements Nested<N>{
    JmxOptionsNested(KafkaJmxOptions item) {
      this.builder = new KafkaJmxOptionsBuilder(this, item);
    }
    KafkaJmxOptionsBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withJmxOptions(builder.build());
    }
    
    public N endJmxOptions() {
      return and();
    }
    
  
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withJvmOptions(builder.build());
    }
    
    public N endJvmOptions() {
      return and();
    }
    
  
  }
  public class JmxPrometheusExporterMetricsConfigNested<N> extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>> implements Nested<N>{
    JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
      this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
    }
    JmxPrometheusExporterMetricsBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withMetricsConfig(builder.build());
    }
    
    public N endJmxPrometheusExporterMetricsConfig() {
      return and();
    }
    
  
  }
  public class JaegerTracingNested<N> extends JaegerTracingFluent<JaegerTracingNested<N>> implements Nested<N>{
    JaegerTracingNested(JaegerTracing item) {
      this.builder = new JaegerTracingBuilder(this, item);
    }
    JaegerTracingBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withTracing(builder.build());
    }
    
    public N endJaegerTracing() {
      return and();
    }
    
  
  }
  public class OpenTelemetryTracingNested<N> extends OpenTelemetryTracingFluent<OpenTelemetryTracingNested<N>> implements Nested<N>{
    OpenTelemetryTracingNested(OpenTelemetryTracing item) {
      this.builder = new OpenTelemetryTracingBuilder(this, item);
    }
    OpenTelemetryTracingBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withTracing(builder.build());
    }
    
    public N endOpenTelemetryTracing() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends KafkaConnectTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(KafkaConnectTemplate item) {
      this.builder = new KafkaConnectTemplateBuilder(this, item);
    }
    KafkaConnectTemplateBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }
  public class ExternalConfigurationNested<N> extends ExternalConfigurationFluent<ExternalConfigurationNested<N>> implements Nested<N>{
    ExternalConfigurationNested(ExternalConfiguration item) {
      this.builder = new ExternalConfigurationBuilder(this, item);
    }
    ExternalConfigurationBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withExternalConfiguration(builder.build());
    }
    
    public N endExternalConfiguration() {
      return and();
    }
    
  
  }
  public class RackNested<N> extends RackFluent<RackNested<N>> implements Nested<N>{
    RackNested(Rack item) {
      this.builder = new RackBuilder(this, item);
    }
    RackBuilder builder;
    
    public N and() {
      return (N) AbstractKafkaConnectSpecFluent.this.withRack(builder.build());
    }
    
    public N endRack() {
      return and();
    }
    
  
  }

}