package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StatefulSetTemplateBuilder extends StatefulSetTemplateFluent<StatefulSetTemplateBuilder> implements VisitableBuilder<StatefulSetTemplate,StatefulSetTemplateBuilder>{
  public StatefulSetTemplateBuilder() {
    this(new StatefulSetTemplate());
  }
  
  public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent) {
    this(fluent, new StatefulSetTemplate());
  }
  
  public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent,StatefulSetTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StatefulSetTemplateBuilder(StatefulSetTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StatefulSetTemplateFluent<?> fluent;
  
  public StatefulSetTemplate build() {
    StatefulSetTemplate buildable = new StatefulSetTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setPodManagementPolicy(fluent.getPodManagementPolicy());
    return buildable;
  }
  

}