package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceTemplateBuilder extends ResourceTemplateFluent<ResourceTemplateBuilder> implements VisitableBuilder<ResourceTemplate,ResourceTemplateBuilder>{
  public ResourceTemplateBuilder() {
    this(new ResourceTemplate());
  }
  
  public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent) {
    this(fluent, new ResourceTemplate());
  }
  
  public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent,ResourceTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceTemplateBuilder(ResourceTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceTemplateFluent<?> fluent;
  
  public ResourceTemplate build() {
    ResourceTemplate buildable = new ResourceTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}