package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodTemplateBuilder extends PodTemplateFluent<PodTemplateBuilder> implements VisitableBuilder<PodTemplate,PodTemplateBuilder>{
  public PodTemplateBuilder() {
    this(new PodTemplate());
  }
  
  public PodTemplateBuilder(PodTemplateFluent<?> fluent) {
    this(fluent, new PodTemplate());
  }
  
  public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodTemplateBuilder(PodTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodTemplateFluent<?> fluent;
  
  public PodTemplate build() {
    PodTemplate buildable = new PodTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setImagePullSecrets(fluent.getImagePullSecrets());
    buildable.setSecurityContext(fluent.getSecurityContext());
    buildable.setTerminationGracePeriodSeconds(fluent.getTerminationGracePeriodSeconds());
    buildable.setAffinity(fluent.getAffinity());
    buildable.setTolerations(fluent.getTolerations());
    buildable.setTopologySpreadConstraints(fluent.getTopologySpreadConstraints());
    buildable.setPriorityClassName(fluent.getPriorityClassName());
    buildable.setSchedulerName(fluent.getSchedulerName());
    buildable.setHostAliases(fluent.getHostAliases());
    buildable.setEnableServiceLinks(fluent.getEnableServiceLinks());
    buildable.setTmpDirSizeLimit(fluent.getTmpDirSizeLimit());
    buildable.setVolumes(fluent.buildVolumes());
    return buildable;
  }
  

}