package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodDisruptionBudgetTemplateBuilder extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetTemplateBuilder> implements VisitableBuilder<PodDisruptionBudgetTemplate,PodDisruptionBudgetTemplateBuilder>{
  public PodDisruptionBudgetTemplateBuilder() {
    this(new PodDisruptionBudgetTemplate());
  }
  
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent) {
    this(fluent, new PodDisruptionBudgetTemplate());
  }
  
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent,PodDisruptionBudgetTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodDisruptionBudgetTemplateFluent<?> fluent;
  
  public PodDisruptionBudgetTemplate build() {
    PodDisruptionBudgetTemplate buildable = new PodDisruptionBudgetTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setMaxUnavailable(fluent.getMaxUnavailable());
    return buildable;
  }
  

}