package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MetadataTemplateBuilder extends MetadataTemplateFluent<MetadataTemplateBuilder> implements VisitableBuilder<MetadataTemplate,MetadataTemplateBuilder>{
  public MetadataTemplateBuilder() {
    this(new MetadataTemplate());
  }
  
  public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent) {
    this(fluent, new MetadataTemplate());
  }
  
  public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent,MetadataTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MetadataTemplateBuilder(MetadataTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MetadataTemplateFluent<?> fluent;
  
  public MetadataTemplate build() {
    MetadataTemplate buildable = new MetadataTemplate();
    buildable.setLabels(fluent.getLabels());
    buildable.setAnnotations(fluent.getAnnotations());
    return buildable;
  }
  

}