package io.strimzi.api.kafka.model.common.template;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JmxTransTemplateFluent<A extends JmxTransTemplateFluent<A>> extends BaseFluent<A>{
  public JmxTransTemplateFluent() {
  }
  
  public JmxTransTemplateFluent(JmxTransTemplate instance) {
    this.copyInstance(instance);
  }
  private DeploymentTemplateBuilder deployment;
  private PodTemplateBuilder pod;
  private ContainerTemplateBuilder container;
  private ResourceTemplateBuilder serviceAccount;
  
  protected void copyInstance(JmxTransTemplate instance) {
    instance = (instance != null ? instance : new JmxTransTemplate());
    if (instance != null) {
          this.withDeployment(instance.getDeployment());
          this.withPod(instance.getPod());
          this.withContainer(instance.getContainer());
          this.withServiceAccount(instance.getServiceAccount());
        }
  }
  
  public DeploymentTemplate buildDeployment() {
    return this.deployment != null ? this.deployment.build() : null;
  }
  
  public A withDeployment(DeploymentTemplate deployment) {
    this._visitables.remove("deployment");
    if (deployment != null) {
        this.deployment = new DeploymentTemplateBuilder(deployment);
        this._visitables.get("deployment").add(this.deployment);
    } else {
        this.deployment = null;
        this._visitables.get("deployment").remove(this.deployment);
    }
    return (A) this;
  }
  
  public boolean hasDeployment() {
    return this.deployment != null;
  }
  
  public DeploymentNested<A> withNewDeployment() {
    return new DeploymentNested(null);
  }
  
  public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
    return new DeploymentNested(item);
  }
  
  public DeploymentNested<A> editDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(null));
  }
  
  public DeploymentNested<A> editOrNewDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
  }
  
  public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(item));
  }
  
  public PodTemplate buildPod() {
    return this.pod != null ? this.pod.build() : null;
  }
  
  public A withPod(PodTemplate pod) {
    this._visitables.remove("pod");
    if (pod != null) {
        this.pod = new PodTemplateBuilder(pod);
        this._visitables.get("pod").add(this.pod);
    } else {
        this.pod = null;
        this._visitables.get("pod").remove(this.pod);
    }
    return (A) this;
  }
  
  public boolean hasPod() {
    return this.pod != null;
  }
  
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  
  public ContainerTemplate buildContainer() {
    return this.container != null ? this.container.build() : null;
  }
  
  public A withContainer(ContainerTemplate container) {
    this._visitables.remove("container");
    if (container != null) {
        this.container = new ContainerTemplateBuilder(container);
        this._visitables.get("container").add(this.container);
    } else {
        this.container = null;
        this._visitables.get("container").remove(this.container);
    }
    return (A) this;
  }
  
  public boolean hasContainer() {
    return this.container != null;
  }
  
  public ContainerNested<A> withNewContainer() {
    return new ContainerNested(null);
  }
  
  public ContainerNested<A> withNewContainerLike(ContainerTemplate item) {
    return new ContainerNested(item);
  }
  
  public ContainerNested<A> editContainer() {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(null));
  }
  
  public ContainerNested<A> editOrNewContainer() {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  
  public ContainerNested<A> editOrNewContainerLike(ContainerTemplate item) {
    return withNewContainerLike(java.util.Optional.ofNullable(buildContainer()).orElse(item));
  }
  
  public ResourceTemplate buildServiceAccount() {
    return this.serviceAccount != null ? this.serviceAccount.build() : null;
  }
  
  public A withServiceAccount(ResourceTemplate serviceAccount) {
    this._visitables.remove("serviceAccount");
    if (serviceAccount != null) {
        this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
        this._visitables.get("serviceAccount").add(this.serviceAccount);
    } else {
        this.serviceAccount = null;
        this._visitables.get("serviceAccount").remove(this.serviceAccount);
    }
    return (A) this;
  }
  
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  
  public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
    return new ServiceAccountNested(item);
  }
  
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JmxTransTemplateFluent that = (JmxTransTemplateFluent) o;
    if (!java.util.Objects.equals(deployment, that.deployment)) return false;
    if (!java.util.Objects.equals(pod, that.pod)) return false;
    if (!java.util.Objects.equals(container, that.container)) return false;
    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(deployment,  pod,  container,  serviceAccount,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deployment != null) { sb.append("deployment:"); sb.append(deployment + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount); }
    sb.append("}");
    return sb.toString();
  }
  public class DeploymentNested<N> extends DeploymentTemplateFluent<DeploymentNested<N>> implements Nested<N>{
    DeploymentNested(DeploymentTemplate item) {
      this.builder = new DeploymentTemplateBuilder(this, item);
    }
    DeploymentTemplateBuilder builder;
    
    public N and() {
      return (N) JmxTransTemplateFluent.this.withDeployment(builder.build());
    }
    
    public N endDeployment() {
      return and();
    }
    
  
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    
    public N and() {
      return (N) JmxTransTemplateFluent.this.withPod(builder.build());
    }
    
    public N endPod() {
      return and();
    }
    
  
  }
  public class ContainerNested<N> extends ContainerTemplateFluent<ContainerNested<N>> implements Nested<N>{
    ContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    
    public N and() {
      return (N) JmxTransTemplateFluent.this.withContainer(builder.build());
    }
    
    public N endContainer() {
      return and();
    }
    
  
  }
  public class ServiceAccountNested<N> extends ResourceTemplateFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) JmxTransTemplateFluent.this.withServiceAccount(builder.build());
    }
    
    public N endServiceAccount() {
      return and();
    }
    
  
  }

}