package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JmxTransTemplateBuilder extends JmxTransTemplateFluent<JmxTransTemplateBuilder> implements VisitableBuilder<JmxTransTemplate,JmxTransTemplateBuilder>{
  public JmxTransTemplateBuilder() {
    this(new JmxTransTemplate());
  }
  
  public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent) {
    this(fluent, new JmxTransTemplate());
  }
  
  public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent,JmxTransTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JmxTransTemplateBuilder(JmxTransTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JmxTransTemplateFluent<?> fluent;
  
  public JmxTransTemplate build() {
    JmxTransTemplate buildable = new JmxTransTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setContainer(fluent.buildContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  

}