package io.strimzi.api.kafka.model.common.template;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class InternalServiceTemplateFluent<A extends InternalServiceTemplateFluent<A>> extends BaseFluent<A>{
  public InternalServiceTemplateFluent() {
  }
  
  public InternalServiceTemplateFluent(InternalServiceTemplate instance) {
    this.copyInstance(instance);
  }
  private MetadataTemplateBuilder metadata;
  private IpFamilyPolicy ipFamilyPolicy;
  private List<IpFamily> ipFamilies;
  
  protected void copyInstance(InternalServiceTemplate instance) {
    instance = (instance != null ? instance : new InternalServiceTemplate());
    if (instance != null) {
          this.withMetadata(instance.getMetadata());
          this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
          this.withIpFamilies(instance.getIpFamilies());
        }
  }
  
  public MetadataTemplate buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(MetadataTemplate metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new MetadataTemplateBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new MetadataTemplateBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public IpFamilyPolicy getIpFamilyPolicy() {
    return this.ipFamilyPolicy;
  }
  
  public A withIpFamilyPolicy(IpFamilyPolicy ipFamilyPolicy) {
    this.ipFamilyPolicy = ipFamilyPolicy;
    return (A) this;
  }
  
  public boolean hasIpFamilyPolicy() {
    return this.ipFamilyPolicy != null;
  }
  
  public A addToIpFamilies(int index,IpFamily item) {
    if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
    this.ipFamilies.add(index, item);
    return (A)this;
  }
  
  public A setToIpFamilies(int index,IpFamily item) {
    if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
    this.ipFamilies.set(index, item); return (A)this;
  }
  
  public A addToIpFamilies(io.strimzi.api.kafka.model.common.template.IpFamily... items) {
    if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
    for (IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
  }
  
  public A addAllToIpFamilies(Collection<IpFamily> items) {
    if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<IpFamily>();}
    for (IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
  }
  
  public A removeFromIpFamilies(io.strimzi.api.kafka.model.common.template.IpFamily... items) {
    if (this.ipFamilies == null) return (A)this;
    for (IpFamily item : items) { this.ipFamilies.remove(item);} return (A)this;
  }
  
  public A removeAllFromIpFamilies(Collection<IpFamily> items) {
    if (this.ipFamilies == null) return (A)this;
    for (IpFamily item : items) { this.ipFamilies.remove(item);} return (A)this;
  }
  
  public List<IpFamily> getIpFamilies() {
    return this.ipFamilies;
  }
  
  public IpFamily getIpFamily(int index) {
    return this.ipFamilies.get(index);
  }
  
  public IpFamily getFirstIpFamily() {
    return this.ipFamilies.get(0);
  }
  
  public IpFamily getLastIpFamily() {
    return this.ipFamilies.get(ipFamilies.size() - 1);
  }
  
  public IpFamily getMatchingIpFamily(Predicate<IpFamily> predicate) {
      for (IpFamily item : ipFamilies) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingIpFamily(Predicate<IpFamily> predicate) {
      for (IpFamily item : ipFamilies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIpFamilies(List<IpFamily> ipFamilies) {
    if (ipFamilies != null) {
        this.ipFamilies = new ArrayList();
        for (IpFamily item : ipFamilies) {
          this.addToIpFamilies(item);
        }
    } else {
      this.ipFamilies = null;
    }
    return (A) this;
  }
  
  public A withIpFamilies(io.strimzi.api.kafka.model.common.template.IpFamily... ipFamilies) {
    if (this.ipFamilies != null) {
        this.ipFamilies.clear();
        _visitables.remove("ipFamilies");
    }
    if (ipFamilies != null) {
      for (IpFamily item : ipFamilies) {
        this.addToIpFamilies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIpFamilies() {
    return this.ipFamilies != null && !this.ipFamilies.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InternalServiceTemplateFluent that = (InternalServiceTemplateFluent) o;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(ipFamilyPolicy, that.ipFamilyPolicy)) return false;
    if (!java.util.Objects.equals(ipFamilies, that.ipFamilies)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(metadata,  ipFamilyPolicy,  ipFamilies,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (ipFamilyPolicy != null) { sb.append("ipFamilyPolicy:"); sb.append(ipFamilyPolicy + ","); }
    if (ipFamilies != null && !ipFamilies.isEmpty()) { sb.append("ipFamilies:"); sb.append(ipFamilies); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends MetadataTemplateFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(MetadataTemplate item) {
      this.builder = new MetadataTemplateBuilder(this, item);
    }
    MetadataTemplateBuilder builder;
    
    public N and() {
      return (N) InternalServiceTemplateFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }

}