package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InternalServiceTemplateBuilder extends InternalServiceTemplateFluent<InternalServiceTemplateBuilder> implements VisitableBuilder<InternalServiceTemplate,InternalServiceTemplateBuilder>{
  public InternalServiceTemplateBuilder() {
    this(new InternalServiceTemplate());
  }
  
  public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent) {
    this(fluent, new InternalServiceTemplate());
  }
  
  public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent,InternalServiceTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InternalServiceTemplateBuilder(InternalServiceTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InternalServiceTemplateFluent<?> fluent;
  
  public InternalServiceTemplate build() {
    InternalServiceTemplate buildable = new InternalServiceTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setIpFamilyPolicy(fluent.getIpFamilyPolicy());
    buildable.setIpFamilies(fluent.getIpFamilies());
    return buildable;
  }
  

}