package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeploymentTemplateBuilder extends DeploymentTemplateFluent<DeploymentTemplateBuilder> implements VisitableBuilder<DeploymentTemplate,DeploymentTemplateBuilder>{
  public DeploymentTemplateBuilder() {
    this(new DeploymentTemplate());
  }
  
  public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent) {
    this(fluent, new DeploymentTemplate());
  }
  
  public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent,DeploymentTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeploymentTemplateBuilder(DeploymentTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeploymentTemplateFluent<?> fluent;
  
  public DeploymentTemplate build() {
    DeploymentTemplate buildable = new DeploymentTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setDeploymentStrategy(fluent.getDeploymentStrategy());
    return buildable;
  }
  

}