package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ContainerTemplateBuilder extends ContainerTemplateFluent<ContainerTemplateBuilder> implements VisitableBuilder<ContainerTemplate,ContainerTemplateBuilder>{
  public ContainerTemplateBuilder() {
    this(new ContainerTemplate());
  }
  
  public ContainerTemplateBuilder(ContainerTemplateFluent<?> fluent) {
    this(fluent, new ContainerTemplate());
  }
  
  public ContainerTemplateBuilder(ContainerTemplateFluent<?> fluent,ContainerTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ContainerTemplateBuilder(ContainerTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ContainerTemplateFluent<?> fluent;
  
  public ContainerTemplate build() {
    ContainerTemplate buildable = new ContainerTemplate();
    buildable.setEnv(fluent.buildEnv());
    buildable.setSecurityContext(fluent.getSecurityContext());
    buildable.setVolumeMounts(fluent.getVolumeMounts());
    return buildable;
  }
  

}