package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ContainerEnvVarSourceBuilder extends ContainerEnvVarSourceFluent<ContainerEnvVarSourceBuilder> implements VisitableBuilder<ContainerEnvVarSource,ContainerEnvVarSourceBuilder>{
  public ContainerEnvVarSourceBuilder() {
    this(new ContainerEnvVarSource());
  }
  
  public ContainerEnvVarSourceBuilder(ContainerEnvVarSourceFluent<?> fluent) {
    this(fluent, new ContainerEnvVarSource());
  }
  
  public ContainerEnvVarSourceBuilder(ContainerEnvVarSourceFluent<?> fluent,ContainerEnvVarSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ContainerEnvVarSourceBuilder(ContainerEnvVarSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ContainerEnvVarSourceFluent<?> fluent;
  
  public ContainerEnvVarSource build() {
    ContainerEnvVarSource buildable = new ContainerEnvVarSource();
    buildable.setSecretKeyRef(fluent.getSecretKeyRef());
    buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
    return buildable;
  }
  

}