package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ContainerEnvVarBuilder extends ContainerEnvVarFluent<ContainerEnvVarBuilder> implements VisitableBuilder<ContainerEnvVar,ContainerEnvVarBuilder>{
  public ContainerEnvVarBuilder() {
    this(new ContainerEnvVar());
  }
  
  public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent) {
    this(fluent, new ContainerEnvVar());
  }
  
  public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent,ContainerEnvVar instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ContainerEnvVarBuilder(ContainerEnvVar instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ContainerEnvVarFluent<?> fluent;
  
  public ContainerEnvVar build() {
    ContainerEnvVar buildable = new ContainerEnvVar();
    buildable.setName(fluent.getName());
    buildable.setValue(fluent.getValue());
    buildable.setValueFrom(fluent.buildValueFrom());
    return buildable;
  }
  

}