package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BuildConfigTemplateBuilder extends BuildConfigTemplateFluent<BuildConfigTemplateBuilder> implements VisitableBuilder<BuildConfigTemplate,BuildConfigTemplateBuilder>{
  public BuildConfigTemplateBuilder() {
    this(new BuildConfigTemplate());
  }
  
  public BuildConfigTemplateBuilder(BuildConfigTemplateFluent<?> fluent) {
    this(fluent, new BuildConfigTemplate());
  }
  
  public BuildConfigTemplateBuilder(BuildConfigTemplateFluent<?> fluent,BuildConfigTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BuildConfigTemplateBuilder(BuildConfigTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BuildConfigTemplateFluent<?> fluent;
  
  public BuildConfigTemplate build() {
    BuildConfigTemplate buildable = new BuildConfigTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setPullSecret(fluent.getPullSecret());
    return buildable;
  }
  

}