package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AdditionalVolumeFluent<A extends AdditionalVolumeFluent<A>> extends BaseFluent<A>{
  public AdditionalVolumeFluent() {
  }
  
  public AdditionalVolumeFluent(AdditionalVolume instance) {
    this.copyInstance(instance);
  }
  private String name;
  private SecretVolumeSource secret;
  private ConfigMapVolumeSource configMap;
  private EmptyDirVolumeSource emptyDir;
  private PersistentVolumeClaimVolumeSource persistentVolumeClaim;
  private CSIVolumeSource csi;
  
  protected void copyInstance(AdditionalVolume instance) {
    instance = (instance != null ? instance : new AdditionalVolume());
    if (instance != null) {
          this.withName(instance.getName());
          this.withSecret(instance.getSecret());
          this.withConfigMap(instance.getConfigMap());
          this.withEmptyDir(instance.getEmptyDir());
          this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
          this.withCsi(instance.getCsi());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public SecretVolumeSource getSecret() {
    return this.secret;
  }
  
  public A withSecret(SecretVolumeSource secret) {
    this.secret = secret;
    return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public ConfigMapVolumeSource getConfigMap() {
    return this.configMap;
  }
  
  public A withConfigMap(ConfigMapVolumeSource configMap) {
    this.configMap = configMap;
    return (A) this;
  }
  
  public boolean hasConfigMap() {
    return this.configMap != null;
  }
  
  public EmptyDirVolumeSource getEmptyDir() {
    return this.emptyDir;
  }
  
  public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
    this.emptyDir = emptyDir;
    return (A) this;
  }
  
  public boolean hasEmptyDir() {
    return this.emptyDir != null;
  }
  
  public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
    return this.persistentVolumeClaim;
  }
  
  public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
    this.persistentVolumeClaim = persistentVolumeClaim;
    return (A) this;
  }
  
  public boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  
  public A withNewPersistentVolumeClaim(String claimName,Boolean readOnly) {
    return (A)withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
  }
  
  public CSIVolumeSource getCsi() {
    return this.csi;
  }
  
  public A withCsi(CSIVolumeSource csi) {
    this.csi = csi;
    return (A) this;
  }
  
  public boolean hasCsi() {
    return this.csi != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AdditionalVolumeFluent that = (AdditionalVolumeFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(secret, that.secret)) return false;
    if (!java.util.Objects.equals(configMap, that.configMap)) return false;
    if (!java.util.Objects.equals(emptyDir, that.emptyDir)) return false;
    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;
    if (!java.util.Objects.equals(csi, that.csi)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  secret,  configMap,  emptyDir,  persistentVolumeClaim,  csi,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (emptyDir != null) { sb.append("emptyDir:"); sb.append(emptyDir + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (csi != null) { sb.append("csi:"); sb.append(csi); }
    sb.append("}");
    return sb.toString();
  }
  

}