package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AdditionalVolumeBuilder extends AdditionalVolumeFluent<AdditionalVolumeBuilder> implements VisitableBuilder<AdditionalVolume,AdditionalVolumeBuilder>{
  public AdditionalVolumeBuilder() {
    this(new AdditionalVolume());
  }
  
  public AdditionalVolumeBuilder(AdditionalVolumeFluent<?> fluent) {
    this(fluent, new AdditionalVolume());
  }
  
  public AdditionalVolumeBuilder(AdditionalVolumeFluent<?> fluent,AdditionalVolume instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AdditionalVolumeBuilder(AdditionalVolume instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AdditionalVolumeFluent<?> fluent;
  
  public AdditionalVolume build() {
    AdditionalVolume buildable = new AdditionalVolume();
    buildable.setName(fluent.getName());
    buildable.setSecret(fluent.getSecret());
    buildable.setConfigMap(fluent.getConfigMap());
    buildable.setEmptyDir(fluent.getEmptyDir());
    buildable.setPersistentVolumeClaim(fluent.getPersistentVolumeClaim());
    buildable.setCsi(fluent.getCsi());
    return buildable;
  }
  

}