package io.strimzi.api.kafka.model.common.jmx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaJmxOptionsBuilder extends KafkaJmxOptionsFluent<KafkaJmxOptionsBuilder> implements VisitableBuilder<KafkaJmxOptions,KafkaJmxOptionsBuilder>{
  public KafkaJmxOptionsBuilder() {
    this(new KafkaJmxOptions());
  }
  
  public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent) {
    this(fluent, new KafkaJmxOptions());
  }
  
  public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent,KafkaJmxOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaJmxOptionsBuilder(KafkaJmxOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaJmxOptionsFluent<?> fluent;
  
  public KafkaJmxOptions build() {
    KafkaJmxOptions buildable = new KafkaJmxOptions();
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  

}