package io.strimzi.api.kafka.model.common.authentication;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSourceBuilder;
import java.lang.String;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSourceFluent;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSource;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaClientAuthenticationTlsFluent<A extends KafkaClientAuthenticationTlsFluent<A>> extends BaseFluent<A>{
  public KafkaClientAuthenticationTlsFluent() {
  }
  
  public KafkaClientAuthenticationTlsFluent(KafkaClientAuthenticationTls instance) {
    this.copyInstance(instance);
  }
  private CertAndKeySecretSourceBuilder certificateAndKey;
  
  protected void copyInstance(KafkaClientAuthenticationTls instance) {
    instance = (instance != null ? instance : new KafkaClientAuthenticationTls());
    if (instance != null) {
          this.withCertificateAndKey(instance.getCertificateAndKey());
        }
  }
  
  public CertAndKeySecretSource buildCertificateAndKey() {
    return this.certificateAndKey != null ? this.certificateAndKey.build() : null;
  }
  
  public A withCertificateAndKey(CertAndKeySecretSource certificateAndKey) {
    this._visitables.remove("certificateAndKey");
    if (certificateAndKey != null) {
        this.certificateAndKey = new CertAndKeySecretSourceBuilder(certificateAndKey);
        this._visitables.get("certificateAndKey").add(this.certificateAndKey);
    } else {
        this.certificateAndKey = null;
        this._visitables.get("certificateAndKey").remove(this.certificateAndKey);
    }
    return (A) this;
  }
  
  public boolean hasCertificateAndKey() {
    return this.certificateAndKey != null;
  }
  
  public CertificateAndKeyNested<A> withNewCertificateAndKey() {
    return new CertificateAndKeyNested(null);
  }
  
  public CertificateAndKeyNested<A> withNewCertificateAndKeyLike(CertAndKeySecretSource item) {
    return new CertificateAndKeyNested(item);
  }
  
  public CertificateAndKeyNested<A> editCertificateAndKey() {
    return withNewCertificateAndKeyLike(java.util.Optional.ofNullable(buildCertificateAndKey()).orElse(null));
  }
  
  public CertificateAndKeyNested<A> editOrNewCertificateAndKey() {
    return withNewCertificateAndKeyLike(java.util.Optional.ofNullable(buildCertificateAndKey()).orElse(new CertAndKeySecretSourceBuilder().build()));
  }
  
  public CertificateAndKeyNested<A> editOrNewCertificateAndKeyLike(CertAndKeySecretSource item) {
    return withNewCertificateAndKeyLike(java.util.Optional.ofNullable(buildCertificateAndKey()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaClientAuthenticationTlsFluent that = (KafkaClientAuthenticationTlsFluent) o;
    if (!java.util.Objects.equals(certificateAndKey, that.certificateAndKey)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(certificateAndKey,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certificateAndKey != null) { sb.append("certificateAndKey:"); sb.append(certificateAndKey); }
    sb.append("}");
    return sb.toString();
  }
  public class CertificateAndKeyNested<N> extends CertAndKeySecretSourceFluent<CertificateAndKeyNested<N>> implements Nested<N>{
    CertificateAndKeyNested(CertAndKeySecretSource item) {
      this.builder = new CertAndKeySecretSourceBuilder(this, item);
    }
    CertAndKeySecretSourceBuilder builder;
    
    public N and() {
      return (N) KafkaClientAuthenticationTlsFluent.this.withCertificateAndKey(builder.build());
    }
    
    public N endCertificateAndKey() {
      return and();
    }
    
  
  }

}