package io.strimzi.api.kafka.model.common.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaClientAuthenticationTlsBuilder extends KafkaClientAuthenticationTlsFluent<KafkaClientAuthenticationTlsBuilder> implements VisitableBuilder<KafkaClientAuthenticationTls,KafkaClientAuthenticationTlsBuilder>{
  public KafkaClientAuthenticationTlsBuilder() {
    this(new KafkaClientAuthenticationTls());
  }
  
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent) {
    this(fluent, new KafkaClientAuthenticationTls());
  }
  
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent,KafkaClientAuthenticationTls instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTls instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaClientAuthenticationTlsFluent<?> fluent;
  
  public KafkaClientAuthenticationTls build() {
    KafkaClientAuthenticationTls buildable = new KafkaClientAuthenticationTls();
    buildable.setCertificateAndKey(fluent.buildCertificateAndKey());
    return buildable;
  }
  

}