package io.strimzi.api.kafka.model.common.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaClientAuthenticationScramSha256Builder extends KafkaClientAuthenticationScramSha256Fluent<KafkaClientAuthenticationScramSha256Builder> implements VisitableBuilder<KafkaClientAuthenticationScramSha256,KafkaClientAuthenticationScramSha256Builder>{
  public KafkaClientAuthenticationScramSha256Builder() {
    this(new KafkaClientAuthenticationScramSha256());
  }
  
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256Fluent<?> fluent) {
    this(fluent, new KafkaClientAuthenticationScramSha256());
  }
  
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256Fluent<?> fluent,KafkaClientAuthenticationScramSha256 instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256 instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaClientAuthenticationScramSha256Fluent<?> fluent;
  
  public KafkaClientAuthenticationScramSha256 build() {
    KafkaClientAuthenticationScramSha256 buildable = new KafkaClientAuthenticationScramSha256();
    buildable.setUsername(fluent.getUsername());
    buildable.setPasswordSecret(fluent.buildPasswordSecret());
    return buildable;
  }
  

}