package io.strimzi.api.kafka.model.common.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaClientAuthenticationPlainBuilder extends KafkaClientAuthenticationPlainFluent<KafkaClientAuthenticationPlainBuilder> implements VisitableBuilder<KafkaClientAuthenticationPlain,KafkaClientAuthenticationPlainBuilder>{
  public KafkaClientAuthenticationPlainBuilder() {
    this(new KafkaClientAuthenticationPlain());
  }
  
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent) {
    this(fluent, new KafkaClientAuthenticationPlain());
  }
  
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent,KafkaClientAuthenticationPlain instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlain instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaClientAuthenticationPlainFluent<?> fluent;
  
  public KafkaClientAuthenticationPlain build() {
    KafkaClientAuthenticationPlain buildable = new KafkaClientAuthenticationPlain();
    buildable.setUsername(fluent.getUsername());
    buildable.setPasswordSecret(fluent.buildPasswordSecret());
    return buildable;
  }
  

}