package io.strimzi.api.kafka.model.common.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaClientAuthenticationOAuthBuilder extends KafkaClientAuthenticationOAuthFluent<KafkaClientAuthenticationOAuthBuilder> implements VisitableBuilder<KafkaClientAuthenticationOAuth,KafkaClientAuthenticationOAuthBuilder>{
  public KafkaClientAuthenticationOAuthBuilder() {
    this(new KafkaClientAuthenticationOAuth());
  }
  
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent) {
    this(fluent, new KafkaClientAuthenticationOAuth());
  }
  
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent,KafkaClientAuthenticationOAuth instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuth instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaClientAuthenticationOAuthFluent<?> fluent;
  
  public KafkaClientAuthenticationOAuth build() {
    KafkaClientAuthenticationOAuth buildable = new KafkaClientAuthenticationOAuth();
    buildable.setClientId(fluent.getClientId());
    buildable.setUsername(fluent.getUsername());
    buildable.setScope(fluent.getScope());
    buildable.setAudience(fluent.getAudience());
    buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
    buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
    buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
    buildable.setHttpRetries(fluent.getHttpRetries());
    buildable.setHttpRetryPauseMs(fluent.getHttpRetryPauseMs());
    buildable.setClientSecret(fluent.buildClientSecret());
    buildable.setPasswordSecret(fluent.buildPasswordSecret());
    buildable.setAccessToken(fluent.buildAccessToken());
    buildable.setAccessTokenLocation(fluent.getAccessTokenLocation());
    buildable.setRefreshToken(fluent.buildRefreshToken());
    buildable.setTlsTrustedCertificates(fluent.buildTlsTrustedCertificates());
    buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
    buildable.setMaxTokenExpirySeconds(fluent.getMaxTokenExpirySeconds());
    buildable.setAccessTokenIsJwt(fluent.isAccessTokenIsJwt());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setIncludeAcceptHeader(fluent.isIncludeAcceptHeader());
    buildable.setClientAssertion(fluent.buildClientAssertion());
    buildable.setClientAssertionLocation(fluent.getClientAssertionLocation());
    buildable.setClientAssertionType(fluent.getClientAssertionType());
    buildable.setSaslExtensions(fluent.getSaslExtensions());
    return buildable;
  }
  

}