package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SystemPropertyBuilder extends SystemPropertyFluent<SystemPropertyBuilder> implements VisitableBuilder<SystemProperty,SystemPropertyBuilder>{
  public SystemPropertyBuilder() {
    this(new SystemProperty());
  }
  
  public SystemPropertyBuilder(SystemPropertyFluent<?> fluent) {
    this(fluent, new SystemProperty());
  }
  
  public SystemPropertyBuilder(SystemPropertyFluent<?> fluent,SystemProperty instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SystemPropertyBuilder(SystemProperty instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SystemPropertyFluent<?> fluent;
  
  public SystemProperty build() {
    SystemProperty buildable = new SystemProperty();
    buildable.setName(fluent.getName());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  

}