package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SidecarBuilder extends SidecarFluent<SidecarBuilder> implements VisitableBuilder<Sidecar,SidecarBuilder>{
  public SidecarBuilder() {
    this(new Sidecar());
  }
  
  public SidecarBuilder(SidecarFluent<?> fluent) {
    this(fluent, new Sidecar());
  }
  
  public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SidecarBuilder(Sidecar instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SidecarFluent<?> fluent;
  
  public Sidecar build() {
    Sidecar buildable = new Sidecar();
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    return buildable;
  }
  

}