package io.strimzi.api.kafka.model.common;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProbeFluent<A extends ProbeFluent<A>> extends BaseFluent<A>{
  public ProbeFluent() {
  }
  
  public ProbeFluent(Probe instance) {
    this.copyInstance(instance);
  }
  private int initialDelaySeconds;
  private int timeoutSeconds;
  private Integer periodSeconds;
  private Integer successThreshold;
  private Integer failureThreshold;
  
  protected void copyInstance(Probe instance) {
    instance = (instance != null ? instance : new Probe());
    if (instance != null) {
          this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
          this.withTimeoutSeconds(instance.getTimeoutSeconds());
          this.withPeriodSeconds(instance.getPeriodSeconds());
          this.withSuccessThreshold(instance.getSuccessThreshold());
          this.withFailureThreshold(instance.getFailureThreshold());
        }
  }
  
  public int getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }
  
  public A withInitialDelaySeconds(int initialDelaySeconds) {
    this.initialDelaySeconds = initialDelaySeconds;
    return (A) this;
  }
  
  public boolean hasInitialDelaySeconds() {
    return true;
  }
  
  public int getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  
  public A withTimeoutSeconds(int timeoutSeconds) {
    this.timeoutSeconds = timeoutSeconds;
    return (A) this;
  }
  
  public boolean hasTimeoutSeconds() {
    return true;
  }
  
  public Integer getPeriodSeconds() {
    return this.periodSeconds;
  }
  
  public A withPeriodSeconds(Integer periodSeconds) {
    this.periodSeconds = periodSeconds;
    return (A) this;
  }
  
  public boolean hasPeriodSeconds() {
    return this.periodSeconds != null;
  }
  
  public Integer getSuccessThreshold() {
    return this.successThreshold;
  }
  
  public A withSuccessThreshold(Integer successThreshold) {
    this.successThreshold = successThreshold;
    return (A) this;
  }
  
  public boolean hasSuccessThreshold() {
    return this.successThreshold != null;
  }
  
  public Integer getFailureThreshold() {
    return this.failureThreshold;
  }
  
  public A withFailureThreshold(Integer failureThreshold) {
    this.failureThreshold = failureThreshold;
    return (A) this;
  }
  
  public boolean hasFailureThreshold() {
    return this.failureThreshold != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProbeFluent that = (ProbeFluent) o;
    if (initialDelaySeconds != that.initialDelaySeconds) return false;
    if (timeoutSeconds != that.timeoutSeconds) return false;
    if (!java.util.Objects.equals(periodSeconds, that.periodSeconds)) return false;
    if (!java.util.Objects.equals(successThreshold, that.successThreshold)) return false;
    if (!java.util.Objects.equals(failureThreshold, that.failureThreshold)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(initialDelaySeconds,  timeoutSeconds,  periodSeconds,  successThreshold,  failureThreshold,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("initialDelaySeconds:"); sb.append(initialDelaySeconds + ",");
    sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ",");
    if (periodSeconds != null) { sb.append("periodSeconds:"); sb.append(periodSeconds + ","); }
    if (successThreshold != null) { sb.append("successThreshold:"); sb.append(successThreshold + ","); }
    if (failureThreshold != null) { sb.append("failureThreshold:"); sb.append(failureThreshold); }
    sb.append("}");
    return sb.toString();
  }
  

}