package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PasswordSourceBuilder extends PasswordSourceFluent<PasswordSourceBuilder> implements VisitableBuilder<PasswordSource,PasswordSourceBuilder>{
  public PasswordSourceBuilder() {
    this(new PasswordSource());
  }
  
  public PasswordSourceBuilder(PasswordSourceFluent<?> fluent) {
    this(fluent, new PasswordSource());
  }
  
  public PasswordSourceBuilder(PasswordSourceFluent<?> fluent,PasswordSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PasswordSourceBuilder(PasswordSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PasswordSourceFluent<?> fluent;
  
  public PasswordSource build() {
    PasswordSource buildable = new PasswordSource();
    buildable.setSecretKeyRef(fluent.getSecretKeyRef());
    return buildable;
  }
  

}