package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PasswordSecretSourceBuilder extends PasswordSecretSourceFluent<PasswordSecretSourceBuilder> implements VisitableBuilder<PasswordSecretSource,PasswordSecretSourceBuilder>{
  public PasswordSecretSourceBuilder() {
    this(new PasswordSecretSource());
  }
  
  public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent) {
    this(fluent, new PasswordSecretSource());
  }
  
  public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent,PasswordSecretSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PasswordSecretSourceBuilder(PasswordSecretSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PasswordSecretSourceFluent<?> fluent;
  
  public PasswordSecretSource build() {
    PasswordSecretSource buildable = new PasswordSecretSource();
    buildable.setSecretName(fluent.getSecretName());
    buildable.setPassword(fluent.getPassword());
    return buildable;
  }
  

}