package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JvmOptionsBuilder extends JvmOptionsFluent<JvmOptionsBuilder> implements VisitableBuilder<JvmOptions,JvmOptionsBuilder>{
  public JvmOptionsBuilder() {
    this(new JvmOptions());
  }
  
  public JvmOptionsBuilder(JvmOptionsFluent<?> fluent) {
    this(fluent, new JvmOptions());
  }
  
  public JvmOptionsBuilder(JvmOptionsFluent<?> fluent,JvmOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JvmOptionsBuilder(JvmOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JvmOptionsFluent<?> fluent;
  
  public JvmOptions build() {
    JvmOptions buildable = new JvmOptions();
    buildable.setXmx(fluent.getXmx());
    buildable.setXms(fluent.getXms());
    buildable.setGcLoggingEnabled(fluent.isGcLoggingEnabled());
    buildable.setJavaSystemProperties(fluent.buildJavaSystemProperties());
    buildable.setXx(fluent.getXx());
    return buildable;
  }
  

}